##Split the data into training, calibration and test set
DataSplit<-function(data,n,n_test,n_cal,n_rest)
{
  if(n_test>0)
  {  index_test=sample(1:n,n_test,replace=FALSE)
  data_test=data[index_test,]
  data_rest2=data[-index_test,]
  data_rest=data_rest2[sample(1:dim(data_rest2)[1],n_rest),]
  index_cal=sample(1:dim(data_rest)[1],n_cal)
  data_train=data_rest[-index_cal,]
  data_cal=data_rest[index_cal,]
  return(list(data_train=data_train,data_cal=data_cal,data_test=data_test,data_rest=data_rest))}else
  {
    data_rest=data[sample(1:dim(data)[1],n_rest,replace=FALSE),]
    index_cal=sample(1:dim(data_rest)[1],n_cal)
    data_train=data_rest[-index_cal,]
    data_cal=data_rest[index_cal,]
    return(list(data_train=data_train,data_cal=data_cal,data_test=0,data_rest=data_rest))
  }
  
}

##Selective conformal p-value, return the rejection results by FDP and Power
SCPV<-function(Y_cal,Y_test,b_0,T_cal,T_test,L,V_cal,V_test,alpha){
  Null_cal=which((Y_cal<=b_0)&(T_cal>L))
  Null_test=which((Y_test<=b_0)&(T_test>L))
  Select_cal=which(T_cal>L)
  Select_test=which(T_test>L)
  Al_test=which((Y_test>b_0)&(T_test>L))
  Result_select=ResultCompute(Null_cal,Select_cal,Null_test,Select_test,Al_test,V_cal,V_test,alpha)
  return(Result_select)
}


##Selective conformal p-value for the mean selection rule
MeanSCPV<-function(Y_cal,Y_test,b_0,T_cal,T_test,L,V_cal,V_test,alpha)
{Null_test=which((Y_test<=b_0)&(T_test>L))
Al_test=which((Y_test>b_0)&(T_test>L))
Select_test=which(T_test>L)


p<-c()
for(i in Select_test)
{
  T_cal_null=T_cal[which(Y_cal<=b_0)]
  Null_cal=which((Y_cal<=b_0)&(T_cal>mean(T_test[-i])))
  V_cal_Null=V_cal[Null_cal]
  p[i]<-(length(V_cal_Null[V_cal_Null<V_test[i]])+1)/(length(V_cal_Null)+1)
}

p<-p*length(which((Y_cal<=b_0)&(T_cal>L)))/length(which(T_cal>L))
p_adj=p.adjust(p[Select_test],method = "BH",n=length(p[Select_test]))      
k_hat=length(p_adj[p_adj<alpha])   
TrueNull_test=p[Null_test]
FDP=length(TrueNull_test[TrueNull_test<(k_hat*alpha/length(p_adj))])/(k_hat+1)
TrueAl_test=p[Al_test]
Power=length(TrueAl_test[TrueAl_test<(k_hat*alpha/length(p_adj))])/length(Al_test)
return(list(FDP=FDP,Power=Power))
}

##Ordinary multiple testing
OMT<-function(Y_cal,Y_test,b_0,T_cal,T_test,L,V_cal,V_test,alpha,Bonfer=FALSE,BY=FALSE){
  Null_cal=which(Y_cal<=b_0)
  Null_test=which((Y_test<=b_0)&(T_test>L))
  Al_test=which((Y_test>b_0)&(T_test>L))
  Select_cal=which(Y_cal<=max(Y_cal))
  Select_test=which(T_test>L)
  if(Bonfer==TRUE)
  {
    if(BY==TRUE)
    {
      Result_select=ResultCompute(Null_cal,Select_cal,Null_test,Select_test,Al_test,V_cal,V_test,alpha*length(which(T_test>L))/(length(V_test)*log(length(which(T_test>L)))))
    }else{
      Result_select=ResultCompute(Null_cal,Select_cal,Null_test,Select_test,Al_test,V_cal,V_test,alpha*length(which(T_test>L))/length(V_test))
    }
  }else{
    Result_select=ResultCompute(Null_cal,Select_cal,Null_test,Select_test,Al_test,V_cal,V_test,alpha)
  }    
  
  return(Result_select)
}

##Selection conditional conformal prediction by Bao et.al (2024)
SCOP<-function(Y_cal,Y_cal_hat,Y_test_hat,b_0,T_test,T_cal,L,alpha){
  V_cal=Y_cal-Y_cal_hat
  V_test=b_0-Y_test_hat
  Null_cal=which(Y_cal<=b_0)
  Null_test=which((Y_test<=b_0)&(T_test>L))
  Al_test=which((Y_test>b_0)&(T_test>L))
  Select_cal=which(T_cal>L)
  Select_test=which(T_test>L)
  V_cal_Null=V_cal
  p<-c()
  for (i in 1:length(V_test)) {
    p[i]<-(length(V_cal_Null[V_cal_Null<V_test[i]])+1)/(length(V_cal_Null)+1)
  }
  TrueNull_test=p[Null_test]
  Reject_test=p[Select_test]
  FDP=length(TrueNull_test[TrueNull_test<alpha])/(length(Reject_test[Reject_test<alpha])+1)
  TrueAl_test=p[Al_test]
  Power=length(TrueAl_test[TrueAl_test<alpha])/length(Al_test)
  return(list(FDP=FDP,Power=Power))
}

##Transform the rejection set into FDR and Power
ResultCompute<-function(Null_cal,Select_cal,Null_test,Select_test,Al_test,V_cal,V_test,alpha){
  V_cal_Null=V_cal[Null_cal]
  p<-c()
  for (i in 1:length(V_test)) {
    p[i]<-(length(V_cal_Null[V_cal_Null<=V_test[i]])+1)/(length(V_cal_Null)+1)
  }
  p<-p*length(Null_cal)/length(Select_cal)
  p_adj=p.adjust(p[Select_test],method = "BH",n=length(p[Select_test]))      
  k_hat=length(p_adj[p_adj<alpha])   
  TrueNull_test=p[Null_test]
  FDP=length(TrueNull_test[TrueNull_test<(k_hat*alpha/length(p_adj))])/(k_hat+1)
  TrueAl_test=p[Al_test]
  Power=length(TrueAl_test[TrueAl_test<(k_hat*alpha/length(p_adj))])/length(Al_test)
  return(list(FDP=FDP,Power=Power))
}

NullIndex<-function(y,Value)
{
  if(Value$type=="==A,S"|Value$type=="==A,R")
  {index=which(y==Value$v)}else if(Value$type=="<=A")
  {index=which(y<=Value$v)}else if(Value$type==">=B")
  {index=which(y>=Value$v)}else if(Value$type=="<=A|>=B")
  {index=which(y<=Value$v[1]|y>=Value$v[2])}else if(Value$type==">=A&<=B")
  {index=which(y>=Value$v[1]&y<=Value$v[2])}
  return(index)
}